/** @file   electricfence.cpp
 * @brief   Implementation of ElectricFence - class.
 * @version $Revision: 1.2 $
 * @author  Tomi Lamminsaari
 */

#include "electricfence.h"
#include "settings.h"
#include "objectid.h"

using namespace eng2d;

namespace WeWantWar {

///
/// Static members, constants and datatypes
/// =======================================

float ElectricFence::s_shockMagnitude = 14;
int ElectricFence::s_shockDamage = 70;

const int ElectricFence::FENCETYPE_ELECTRIC;


///
/// Constructors, destructor and operators
/// ======================================
/** Constructor
 */
ElectricFence::ElectricFence( const Vec2D& rBeg, const Vec2D& rEnd ) :
  LightFence( rBeg, rEnd )
{
  // We create a set of Wires that represents the electric sparks between
  // the nodes.
  Gradient g( Color(230,240,250), Color(150,160,190), Color(80,120,170) );
  for ( int i=0; i < 3; i++ ) {
    WindingWire* pW = new WindingWire( rBeg, rEnd, 5, 12 );
    pW->setColorScale( g );
    this->addWire( pW );
  }
  
  Vec2D midPoint( rBeg );
  midPoint += rEnd;
  midPoint /= 2;
  this->attachSoundSource( new SoundSource( "electric", midPoint ) );
  
  // Take the settings
  int t = ObjectID::TYPE_LIGHTFENCE;
  s_shockMagnitude = Settings::floatObjProp( t, "elec_shock:" );
  s_shockDamage = Settings::intObjProp( t, "elec_damage:" );
}



/** Destructor
 */
ElectricFence::~ElectricFence()
{
}

/** Returns the type of this fence
 */
int ElectricFence::fenceType() const
{
  return FENCETYPE_ELECTRIC;
}

} // end of namespace
